#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>  // for for_each_process
#include <linux/mm_types.h>      // for task->mm

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    // header
    seq_puts(m, "PID\tPTE_ALLOC PTE_FREE PTE_SET PMD_ALLOC PMD_FREE PMD_SET PUD_ALLOC PUD_FREE PUD_SET PGD_ALLOC PGD_FREE PGD_SET\n");

    // iterate through all processes
    for_each_process(task) {
        // skip kernel threads
        if (!task->mm)
            continue;

        seq_printf(m, "%d\t%lu %lu %lu %lu %lu %lu %lu %lu %lu %lu %lu %lu\n",
                   task->pid,
                   task->pte_alloc, task->pte_free, task->pte_set,
                   task->pmd_alloc, task->pmd_free, task->pmd_set,
                   task->pud_alloc, task->pud_free, task->pud_set,
                   task->pgd_alloc, task->pgd_free, task->pgd_set);
    }

    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    return 0;
}

fs_initcall(pg_stats_init);

