//cw2 whole file
#include<linux/module.h>
#include<linux/kernel.h>

#include <linux/proc_fs.h>
#include <linux/seq_file.h>


static int pg_stats_proc_show(struct seq_file *m, void *v)
{
    //unsigned int stats[4][3];
    struct task_struct *p;
    for_each_process(p){
        if (p->__state == EXIT_ZOMBIE)
            continue;
        //stats = {{p->pgdc_alloc,p->pgdc_free,p->pgdc_set},{p->pudc_alloc,p->pudc_free,p->pudc_set},{p->pmdc_alloc,p->pmdc_free,p->pmdc_set},{p->ptec_alloc,p->ptec_free,p->ptec_set}};
        seq_printf(m,"%d: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",p->pid,p->pgdc_alloc,p->pgdc_free,
        p->pgdc_set,p->pudc_alloc,p->pudc_free,p->pudc_set,p->pmdc_alloc,p->pmdc_free,p->pmdc_set,p->ptec_alloc,p->ptec_free,p->ptec_set);
    }
	return 0;
}

static int __init proc_pg_stats_init(void)
{
	struct proc_dir_entry *pde;

	pde = proc_create_single("pg_stats", 0, NULL, pg_stats_proc_show);
	//pde_make_permanent(pde);
	return 0;
}

static void __exit proc_pg_stats_cleanup (void){
    remove_proc_entry("pg_stats",NULL);
}
module_init(proc_pg_stats_init);
module_exit(proc_pg_stats_cleanup);
