#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>
#include <linux/mm.h>

static int pg_stats_show(struct seq_file *m, void *v) {
    struct task_struct *task;

    rcu_read_lock();
    for_each_process(task) {
            seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
                task->pid,
                task->pgd_allocate, task->pgd_free, task->pgd_set,
                task->pud_allocate, task->pud_free, task->pud_set,
                task->pmd_allocate, task->pmd_free, task->pmd_set,
                task->pte_allocate, task->pte_free, task->pte_set
            );
    }
    rcu_read_unlock();
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = seq_release,
};



static int __init stats_init(void) {
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    return 0;
}

static void __exit stats_exit(void) {
    remove_proc_entry("pg_stats", NULL);
}

module_init(stats_init);
module_exit(stats_exit);