// CW2
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/task.h>
#include <linux/atomic.h>

static int pg_stats_show(struct seq_file *m, void *v) {
    struct task_struct *task;

    // Iterate over all processes
    rcu_read_lock();
    for_each_process(task) {
        // Skip kernel threads
        if (!task->mm)
            continue;

        seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
                task->pid,
                atomic_read(&task->pgd_alloc),
                atomic_read(&task->pgd_free),
                atomic_read(&task->pgd_set),
                atomic_read(&task->pud_alloc),
                atomic_read(&task->pud_free),
                atomic_read(&task->pud_set),
                atomic_read(&task->pmd_alloc),
                atomic_read(&task->pmd_free),
                atomic_read(&task->pmd_set),
                atomic_read(&task->pte_alloc),
                atomic_read(&task->pte_free),
                atomic_read(&task->pte_set)
        );
    }
    rcu_read_unlock();

    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void) {
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    return 0;
}

static void __exit pg_stats_exit(void) {
    remove_proc_entry("pg_stats", NULL);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");