#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/uaccess.h>

static int proc_show(struct seq_file *m, void *v) {
    struct task_struct *task;
    
    for_each_process(task) {
        if (task->__state == TASK_RUNNING || task->__state == TASK_INTERRUPTIBLE || task->__state == TASK_UNINTERRUPTIBLE) {
            seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n", 
                    task->pid, 
                    task->pgd_alloc, task->pgd_free, task->pgd_set,
                    task->pud_alloc, task->pud_free, task->pud_set,
                    task->pmd_alloc, task->pmd_free, task->pmd_set,
                    task->pte_alloc, task->pte_free, task->pte_set);
        }
    }
    return 0;
}

static int proc_open(struct inode *inode, struct file *file) {
    return single_open(file, proc_show, NULL);
}

static const struct proc_ops proc_fops = {
    .proc_open = proc_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static struct proc_dir_entry *entry;

static int __init procfs_init(void) {
    entry = proc_create("pg_stats", 0, NULL, &proc_fops);

    if (!entry) {
        printk(KERN_ERR "Failed to create /proc/myprocfile\n");
        return -ENOMEM;
    }
    printk(KERN_INFO "Procfs module loaded: /proc/pg_stats\n");
    return 0;
}

static void __exit procfs_exit(void) {
    proc_remove(entry);
    printk(KERN_INFO "Procfs module unloaded: /proc/myprocfile\n");
}

module_init(procfs_init);
module_exit(procfs_exit);