// SPDX-License-Identifier: GPL-2.0
#include <linux/module.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/proc_fs.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;
    
    for_each_process(task) {
        seq_printf(m, "%d: [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]], [[%ld],[%ld],[%ld]]\n",
            task->pid,
            atomic_long_read(&task->pgd_alloc), atomic_long_read(&task->pgd_free), atomic_long_read(&task->pgd_set),
            atomic_long_read(&task->pud_alloc), atomic_long_read(&task->pud_free), atomic_long_read(&task->pud_set),
            atomic_long_read(&task->pmd_alloc), atomic_long_read(&task->pmd_free), atomic_long_read(&task->pmd_set),
            atomic_long_read(&task->pte_alloc), atomic_long_read(&task->pte_free), atomic_long_read(&task->pte_set));
    }
    return 0;
}

static int __init pg_stats_init(void)
{
    proc_create_single("pg_stats", 0, NULL, pg_stats_show);
    pr_info("pg_stats module loaded\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats module unloaded\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Your Name");
MODULE_DESCRIPTION("Procfs module for tracking page table operations");

