#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>
#include <linux/sched.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m, "[%d]: [[%lu,%lu,%lu]], [[%lu,%lu,%lu]], "
                        "[[%lu,%lu,%lu]], [[%lu,%lu,%lu]]\n",
                   task->pid,
                   task->pgd_alloc, task->pgd_free, task->pgd_set,
                   task->pud_alloc, task->pud_free, task->pud_set,
                   task->pmd_alloc, task->pmd_free, task->pmd_set,
                   task->pte_alloc, task->pte_free, task->pte_set);
    }
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}


static const struct proc_ops pg_stats_fops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};

static int __init proc_pg_stats_init(void)
{
    if (!proc_create("pg_stats", 0444, NULL, &pg_stats_fops)) {
        pr_err("proc_pg_stats: failed to create entry\n");
        return -ENOMEM;
    }
    pr_info("proc_pg_stats: /proc/pg_stats created\n");
    return 0;
}

fs_initcall(proc_pg_stats_init);

