#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/module.h>
#include <linux/atomic.h>

static struct proc_dir_entry *pg_stats_entry;


static int pg_stats_show(struct seq_file *m, void *v) {
    struct task_struct *task;

    for_each_process(task) {

        seq_printf(m, "[%d]: ", task->pid);
        for  (int level = 0; level < PAGE_TABLE_LEVELS; level++) {
            long alloc = atomic_long_read(&task->count_alloc[level]);
            long free = atomic_long_read(&task->count_free[level]);
            long set = atomic_long_read(&task->count_set[level]);
            seq_printf(m, "[[%ld],[%ld],[%ld]]", alloc, free, set);
            if (level != PAGE_TABLE_LEVELS - 1) {
                seq_printf(m, ",");
            }
        }
        seq_printf(m, "\n");
    }
    return 0;

}

static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);

}


static const struct proc_ops pg_stats_fops = {
    .proc_open = pg_stats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void) {
    pg_stats_entry = proc_create("pg_stats", 0444, NULL, &pg_stats_fops);
    if (!pg_stats_entry) {

        pr_err("Error creating /proc/pg_stas entry \n");
        return -ENOMEM;
    }
    return 0;
}

static void __exit pg_stats_exit(void) {
    proc_remove(pg_stats_entry);
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
