#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Star Rothkopf");
MODULE_DESCRIPTION("Page table operation statistics for each process");

// Function to show collected statistics
static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    for_each_process(task) {
        seq_printf(m, "%d: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
            task->pid,
            task->pgd_alloc_count, task->pgd_free_count, task->pgd_set_count,
            task->pud_alloc_count, task->pud_free_count, task->pud_set_count,
            task->pmd_alloc_count, task->pmd_free_count, task->pmd_set_count,
            task->pte_alloc_count, task->pte_free_count, task->pte_set_count
        );
    }
    return 0;
}


// Open function for proc file
static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);
}

// File operations structure
static const struct proc_ops pg_stats_ops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};


// Initialization function
static int __init pg_stats_init(void) {
    proc_create("pg_stats", 0444, NULL, &pg_stats_ops);
	printk(KERN_INFO "pg_stats module loaded.\n");
    return 0;
}

// Exit function
static void __exit pg_stats_exit(void) {
    remove_proc_entry("pg_stats", NULL);
    printk(KERN_INFO "pg_stats module removed.\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

