#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/blkdev.h>
#include "internal.h"

static int pg_stats_show(struct seq_file *f, void *v)
{
	// CW2 Task 1: For each process, display just its pid for now.
	struct task_struct *task = (struct task_struct *)v;
	seq_printf(
		f,
		"[%u]: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
		task->pid, task->pgd_alloc, task->pgd_free, task->pgd_set,
		task->pud_alloc, task->pud_free, task->pud_set, task->pmd_alloc,
		task->pmd_free, task->pmd_set, task->pte_alloc, task->pte_free,
		task->pte_set);

	return 0;
}

static void *pg_stats_start(struct seq_file *f, loff_t *pos)
{
	// CW2 Task 1: Start from the first process.
	struct task_struct *task;
	loff_t i = 0;

	for_each_process(task) {
		if (i++ == *pos)
			return task;
	}
	return NULL;
}

static void *pg_stats_next(struct seq_file *f, void *v, loff_t *pos)
{
	// CW2 Task 1: Get the next process.
	struct task_struct *task = (struct task_struct *)v;
	(*pos)++;
	task = next_task(task);
	if (task == &init_task)
		return NULL;
	return task;
}

static void pg_stats_stop(struct seq_file *f, void *v)
{
	/* Nothing to do */
}

static const struct seq_operations pg_stats_ops = { .start = pg_stats_start,
						    .next = pg_stats_next,
						    .stop = pg_stats_stop,
						    .show = pg_stats_show };

static int __init proc_pg_stats_init(void)
{
	struct proc_dir_entry *pde;

	pde = proc_create_seq("pg_stats", 0, NULL, &pg_stats_ops);
	pde_make_permanent(pde);
	return 0;
}
fs_initcall(proc_pg_stats_init);
