#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/seq_file.h>
#include <linux/time.h>
#include <linux/time_namespace.h>
#include <linux/kernel_stat.h>
#include "internal.h"

// CW2 Task1

static int pg_stats_proc_show(struct seq_file* m, void *v) {
    struct task_struct *task;
    
    for_each_process(task) { 
        seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
            task->pid,
            task->pgd_alloc,
            task->pgd_free,
            task->pgd_set,
            task->pud_alloc,
            task->pud_free,
            task->pud_set,
            task->pmd_alloc,
            task->pmd_free,
            task->pmd_set,
            task->pte_alloc,
            task->pte_free,
            task->pte_set
        );
    }

    return 0;
}

static int __init proc_pg_stats_init(void) {
    struct proc_dir_entry *pde;

    pde = proc_create_single("pg_stats", 0, NULL, pg_stats_proc_show);
    pde_make_permanent(pde);

    return 0;
}
fs_initcall(proc_pg_stats_init);
