#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>       
#include <linux/sched/signal.h>
#include <linux/uaccess.h>     
#include <linux/atomic.h>  

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    rcu_read_lock();
    for_each_process(task)
    {
        seq_printf(m,
            "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
            task->pid,
            atomic_read(&task->pgd_alloc_ctr),
            atomic_read(&task->pgd_free_ctr),
            atomic_read(&task->pgd_set_ctr),
            atomic_read(&task->pud_alloc_ctr),
            atomic_read(&task->pud_free_ctr),
            atomic_read(&task->pud_set_ctr),
            atomic_read(&task->pmd_alloc_ctr),
            atomic_read(&task->pmd_free_ctr),
            atomic_read(&task->pmd_set_ctr),
            atomic_read(&task->pte_alloc_ctr),
            atomic_read(&task->pte_free_ctr),
            atomic_read(&task->pte_set_ctr)
        );
    }
    rcu_read_unlock();
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}


static const struct proc_ops pg_stats_ops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};


static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_ops);
    pr_info("pg_stats module loaded. /proc/pg_stats created.\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats module unloaded. /proc/pg_stats removed.\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
