// SPDX-License-Identifier: GPL-2.0-only
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched/signal.h>  // For for_each_process()

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;
    /* Iterate over all processes */
    for_each_process(task) {
        seq_printf(m,
            "%d: [[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]], "
            "[[%lu],[%lu],[%lu]], [[%lu],[%lu],[%lu]]\n",
            task->pid,
            task->pgd_alloc, task->pgd_free, task->pgd_set,
            task->pud_alloc, task->pud_free, task->pud_set,
            task->pmd_alloc, task->pmd_free, task->pmd_set,
            task->pte_alloc, task->pte_free, task->pte_set);
    }
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_proc_ops = {
    .proc_open       = pg_stats_open,
    .proc_read_iter  = seq_read_iter,  /* Use the iter version for read */
    .proc_lseek      = seq_lseek,      /* Use the same seq_lseek; note the field name is proc_lseek */
    .proc_release    = single_release,
};


static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pg_stats_proc_ops);
    pr_info("pg_stats proc entry created\n");
    return 0;
}

static void __exit pg_stats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
    pr_info("pg_stats proc entry removed\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("YOUR_STUDENT_NUMBER");
MODULE_DESCRIPTION("Proc interface for page table operation statistics");
