#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/uaccess.h>
#include <linux/string.h>
#include <linux/sched.h>
#include <linux/seq_file.h>

#define PROC_FILENAME "pg_stats"

static struct proc_dir_entry *proc_entry;

static int hello_proc_show(struct seq_file *m, void *v)
{
	struct task_struct *task;
	for_each_process(task) {
		// [pid]: [[pgd_alloc],[pgd_free],[pgd_set]], [[pud_alloc],[pud_free],[pud_set]], [[pmd_alloc],[pmd_free],[pmd_set]], [[pte_alloc],[pte_free],[pte_set]]
		seq_printf(
			m,
			"%d: [[%llu],[%llu],[%llu]], [[%llu],[%llu],[%llu]], [[%llu],[%llu],[%llu]], [[%llu],[%llu],[%llu]]\n",
			task->pid, task->pgd_alloc, task->pgd_free,
			task->pgd_set, task->pud_alloc, task->pud_free,
			task->pud_set, task->pmd_alloc, task->pmd_free,
			task->pmd_set, task->pte_alloc, task->pte_free,
			task->pte_set);
	}
	return 0;
}
static int hello_proc_open(struct inode *inode, struct file *file)
{
	return single_open(file, hello_proc_show, NULL);
}

static const struct proc_ops hello_proc_ops = {
	.proc_open = hello_proc_open,
	.proc_read = seq_read,
	.proc_lseek = seq_lseek,
	.proc_release = single_release,
};

static int __init hello_init(void)
{
	proc_entry = proc_create(PROC_FILENAME, 0, NULL, &hello_proc_ops);
	if (!proc_entry) {
		pr_err("Failed to create /proc/%s\n", PROC_FILENAME);
		return -ENOMEM;
	}
	pr_info("/proc/%s created\n", PROC_FILENAME);
	return 0;
}

static void __exit hello_exit(void)
{
	proc_remove(proc_entry);
	pr_info("/proc/%s removed\n", PROC_FILENAME);
}

module_init(hello_init);
module_exit(hello_exit);
