#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>

static int pg_stats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;

    rcu_read_lock();
    for_each_process(task) {
    //    if (task->mm && task == task->group_leader) { // user processes only
        if (task == task->group_leader) { // all active processes
            seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
                       task->pid,
                       atomic_read(&task->pt_stats.pgd_alloc),
                       atomic_read(&task->pt_stats.pgd_free),
                       atomic_read(&task->pt_stats.pgd_set),
                       atomic_read(&task->pt_stats.pud_alloc),
                       atomic_read(&task->pt_stats.pud_free),
                       atomic_read(&task->pt_stats.pud_set),
                       atomic_read(&task->pt_stats.pmd_alloc),
                       atomic_read(&task->pt_stats.pmd_free),
                       atomic_read(&task->pt_stats.pmd_set),
                       atomic_read(&task->pt_stats.pte_alloc),
                       atomic_read(&task->pt_stats.pte_free),
                       atomic_read(&task->pt_stats.pte_set));
        }
    }
    rcu_read_unlock();
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_proc_ops = {
    .proc_open    = pg_stats_open,
    .proc_read    = seq_read,
    .proc_lseek   = seq_lseek,
    .proc_release = single_release,
};

static int __init pg_stats_init(void)
{
    proc_create("pg_stats", 0444, NULL, &pg_stats_proc_ops);
    return 0;
}

fs_initcall(pg_stats_init);