#include <linux/init.h>
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>
#include <linux/proc_fs.h>
#include <linux/fs.h>

static int show_pg_stats(struct seq_file *m, void *v)
{
    struct task_struct *task;
    
    for_each_process(task){
        seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
                    task->pid,
                    task->pgd_alloc,
                    task->pgd_free,
                    task->pgd_set,
                    task->pud_alloc,
                    task->pud_free,
                    task->pud_set,
                    task->pmd_alloc,
                    task->pmd_free,
                    task->pmd_set,
                    task->pte_alloc,
                    task->pte_free,
                    task->pte_set);
    }

    return 0;

}


static int pg_stats_open(struct inode *inode, struct file *file)
{
	return single_open(file, show_pg_stats, NULL);
}


static const struct proc_ops pg_stats_proc_ops = {
	.proc_open	= pg_stats_open,
	.proc_read	= seq_read,
	.proc_lseek	= seq_lseek,
	.proc_release	= single_release,
};

static int __init proc_pg_stats_init(void)
{
	proc_create("pg_stats", 0, NULL, &pg_stats_proc_ops);
	return 0;
}
fs_initcall(proc_pg_stats_init);