#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/proc_fs.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/seq_file.h>
#include <linux/errno.h>
#include <linux/sched/task.h>

static int pgstats_show(struct seq_file *m, void *v)
{
    struct task_struct *task;
    for_each_process(task) {
        seq_printf(m, "%d: [%d, %d, %d], [%d, %d, %d], [%d, %d, %d], [%d, %d, %d]\n", task->pid, 
        task->pgdalloc, task->pgdfree, task->pgdset, 
        task->pudalloc, task->pudfree, task->pudset, 
        task->pmdalloc, task->pmdfree, task->pmdset, 
        task->ptealloc, task->ptefree, task->pteset);
    }

    return 0;
}

static int pgstats_open(struct inode *inode, struct file *file)
{
    return single_open(file, pgstats_show, NULL);
}

static const struct proc_ops pgstats_ops = {
    .proc_open = pgstats_open,
    .proc_read = seq_read,
    .proc_lseek = seq_lseek,
    .proc_release = single_release,
};

static int pgstats_init(void)
{
    proc_create("pg_stats", 0, NULL, &pgstats_ops);
    return 0;
}

static void pgstats_exit(void)
{
    remove_proc_entry("pg_stats", NULL);
}

module_init(pgstats_init);
module_exit(pgstats_exit);