// SPDX-License-Identifier: GPL-2.0
#include <linux/cpufreq.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>

/*CW2 Task 1*/
static void *p_start(struct seq_file *m, loff_t *pos)
{
	if (*pos >= 1)
		return NULL;
	return (void *) 1;
}

static void *p_next(struct seq_file *m, void *v, loff_t *pos)
{
	*pos = 1;
	return NULL;
}

static void p_stop(struct seq_file *m, void *v)
{
}

static int p_show(struct seq_file *m, void *v)
{
	struct task_struct *begin = find_task_by_vpid(1);
	seq_printf(m, "[%d] : [[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]]]\n", begin->pid,
		begin->allocate_pgd_count, begin->free_pgd_count, begin->set_pgd_count,
		begin->allocate_pud_count, begin->free_pud_count, begin->set_pud_count,
		begin->allocate_pmd_count, begin->free_pmd_count, begin->set_pmd_count,
		begin->allocate_pte_count, begin->free_pte_count, begin->set_pte_count);

	struct task_struct *meow = container_of(begin->children.next, struct task_struct, sibling);
	do {
		seq_printf(m, "[%d] : [[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]]]\n", meow->pid,
			meow->allocate_pgd_count, meow->free_pgd_count, meow->set_pgd_count,
			meow->allocate_pud_count, meow->free_pud_count, meow->set_pud_count,
			meow->allocate_pmd_count, meow->free_pmd_count, meow->set_pmd_count,
			meow->allocate_pte_count, meow->free_pte_count, meow->set_pte_count);
		struct task_struct *kitten = NULL;
		if (meow->children.next != &meow->children) {
			kitten = container_of(meow->children.next, struct task_struct, sibling);
			while(kitten != NULL)
			{
				seq_printf(m, "[%d] : [[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]],[[%lu],[%lu],[%lu]]]\n", kitten->pid,
					kitten->allocate_pgd_count, kitten->free_pgd_count, kitten->set_pgd_count,
					kitten->allocate_pud_count, kitten->free_pud_count, kitten->set_pud_count,
					kitten->allocate_pmd_count, kitten->free_pmd_count, kitten->set_pmd_count,
					kitten->allocate_pte_count, kitten->free_pte_count, kitten->set_pte_count);
				if (kitten->sibling.next != &kitten->real_parent->children)
				{
					kitten = container_of(kitten->sibling.next, struct task_struct, sibling);
				}
				else
				{
					for(;;)
					{
						if (kitten->children.next == &kitten->children)
						{
							if (kitten->real_parent->children.next == &kitten->sibling)
							{
								kitten = NULL;
								break;
							}
							else
							{
								kitten = container_of(kitten->sibling.prev, struct task_struct, sibling);
								continue;
							}

						}
						else
						{
							kitten = container_of(kitten->children.next, struct task_struct, sibling);
							break;
						}
					}
				}
			}
		}
		meow = container_of(meow->sibling.next, struct task_struct, sibling);
	} while(meow->sibling.next != &begin->children);

	return 0;
}

const struct seq_operations pgstats_op = {
	.start	= p_start,
	.next	= p_next,
	.stop	= p_stop,
	.show	= p_show
};

static int pgstat_open(struct inode *inode, struct file *file)
{
	return seq_open(file, &pgstats_op);
}

static const struct proc_ops pgstats_proc_ops = {
	.proc_flags	= PROC_ENTRY_PERMANENT,
	.proc_open	= pgstat_open,
	.proc_read_iter	= seq_read_iter,
	.proc_lseek	= seq_lseek,
	.proc_release	= seq_release,
};


static int __init proc_cpuinfo_init(void)
{
	proc_create("pg_stats", 0, NULL, &pgstats_proc_ops);
	return 0;
}
fs_initcall(proc_cpuinfo_init);
