#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define MEMORY_SIZE (1024 * 1024 * 1024) // 1 GB

int main() {
    printf("Process ID: %d\n", getpid());
    
    // Allocate a large chunk of memory
    char *memory = (char *)malloc(MEMORY_SIZE);
    if (!memory) {
        perror("malloc failed");
        return 1;
    }
    
    // Access memory at various offsets
    for (int i = 0; i < MEMORY_SIZE; i += 4096) {
        memory[i] = (char)i;
    }
    
    //printf("Memory operations completed.\n");
    //printf("Press Enter to exit...\n");
    getchar();
    
    // Free the memory
    free(memory);
    
    return 0;
}