#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/sched/signal.h>
#include <linux/seq_file.h>

#define PG_STATS_FILENAME "pg_stats"

static int pg_stats_show(struct seq_file *m, void *v)
{
	struct task_struct *task;
	for_each_process(task) {
		seq_printf(m, "[%d]: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n", task->pid,
			task->pgd_alloc_count, task->pgd_free_count, task->pgd_set_count,
			task->pud_alloc_count, task->pud_free_count, task->pud_set_count,
			task->pmd_alloc_count, task->pmd_free_count, task->pmd_set_count,
			task->pte_alloc_count, task->pte_free_count, task->pte_set_count
		);
	}

	return 0;
}

static int __init pg_stats_init(void) {
	printk(KERN_INFO "Loading pg_stats\n");

	if (!proc_create_single(PG_STATS_FILENAME, 0, NULL, pg_stats_show)) {
		printk(KERN_ERR "Failed to create file %s\n", PG_STATS_FILENAME);
		return -ENOMEM;
	}

	return 0;
}

static void __exit pg_stats_exit(void) {
	printk(KERN_INFO "Unloading pg_stats\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
