#include <linux/init.h>
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/sched.h>
#include <linux/sched/signal.h>

static int pg_stats_show(struct seq_file *m, void *v) {
    struct task_struct *task;
    
    for_each_process(task) {
        seq_printf(m, "%d: [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]], [[%d],[%d],[%d]]\n",
            task->pid,
            task->action_counter[0][0], task->action_counter[0][1], task->action_counter[0][2],
            task->action_counter[1][0], task->action_counter[1][1], task->action_counter[1][2],
            task->action_counter[2][0], task->action_counter[2][1], task->action_counter[2][2],
            task->action_counter[3][0], task->action_counter[3][1], task->action_counter[3][2]
        );
    }
    return 0;
}

static int pg_stats_open(struct inode *inode, struct file *file) {
    return single_open(file, pg_stats_show, NULL);
}

static const struct proc_ops pg_stats_fops = {
	.proc_flags	= PROC_ENTRY_PERMANENT,
	.proc_open	= pg_stats_open,
	.proc_read_iter	= seq_read_iter,
	.proc_lseek	= seq_lseek,
	.proc_release	= single_release,
};

static int __init pg_stats_init(void) {
    proc_create("pg_stats", 0, NULL, &pg_stats_fops);
    printk(KERN_INFO "pg_stats module loaded\n");
    return 0;
}

static void __exit pg_stats_exit(void) {
    remove_proc_entry("pg_stats", NULL);
    printk(KERN_INFO "pg_stats module unloaded\n");
}

module_init(pg_stats_init);
module_exit(pg_stats_exit);
