#include <linux/seq_file.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/module.h>    
#include <linux/init.h>  

static void *pg_stat_seq_start(struct seq_file *m, loff_t *pos) {
	rcu_read_lock(); //For stability
    	return seq_list_start(&init_task.tasks, *pos);
}

static void *pg_stat_seq_next(struct seq_file *m, void *v, loff_t *pos) {
    	return seq_list_next(v, &init_task.tasks, pos);
}

static void pg_stat_seq_stop(struct seq_file *m, void *v) {
	rcu_read_unlock();}

static int pg_stat_seq_show(struct seq_file *m, void *v) {//Print out all stastics 
    	struct task_struct *task = list_entry(v, struct task_struct, tasks);
    	seq_printf(m, "%d: [[%d,%d,%d], [%d,%d,%d], [%d,%d,%d], [%d,%d,%d]]\n",
        	task->pid,
        	atomic_read(&task->page_allocate_pgd), atomic_read(&task->page_free_pgd), atomic_read(&task->page_set_pgd),
        	atomic_read(&task->page_allocate_pud), atomic_read(&task->page_free_pud), atomic_read(&task->page_set_pud),
        	atomic_read(&task->page_allocate_pmd), atomic_read(&task->page_free_pmd), atomic_read(&task->page_set_pmd),
        	atomic_read(&task->page_allocate_pte), atomic_read(&task->page_free_pte), atomic_read(&task->page_set_pte));//using seq_peintf to print out
    	return 0;
}

static const struct seq_operations pg_stat_seq_ops = {//Create operations for pg_stats
    	.start = pg_stat_seq_start,
    	.next  = pg_stat_seq_next,
    	.stop  = pg_stat_seq_stop,
    	.show  = pg_stat_seq_show,
};


static int __init pg_stat_init(void) {
    	struct proc_dir_entry *entry;
    	entry = proc_create_seq("pg_stats", 0, NULL, &pg_stat_seq_ops);
    	if (!entry) {
    	//In case if the module fails
        	pr_err("Error: pg_stats fails\n");
        	return -ENOMEM;
    	}
    	return 0;
}
module_init(pg_stat_init);

