#ifndef _READER_FILTER_H
#define _READER_FILTER_H

struct filter_ctx {
    struct dir_context ctx;
    struct dir_context *orig_ctx;
    const char *filter_type;
    struct dentry *dir;
    struct file *file; 
};

struct dentry *lookup_one_len(const char *name, struct dentry *base, int len);
int iterate_shared(struct file *file, struct dir_context *ctx);
bool filtered_filldir(struct dir_context *ctx, const char *name, int namlen, loff_t offset, u64 ino, unsigned int d_type);
bool should_filter(const char *filter_type, struct dentry *dentry);

#endif /* _READER_FILTER_H */
