                          CLIENT SIDE (Node 1)
┌─────────────────────────────────────────────────────────────────────────────┐

    User Space                Kernel Space
        │                        │
    ┌───▼───┐                    │
    │  PID  │◄─── echo 470 ─────►│
    │ "470" │                    │
    └───┬───┘                    │
        │                        │
        ▼                        │
┌─────────────────────────────────────────────┐
│         vmotions_proc_write()               │◄── /proc/vmotions
│    • Parse PID from user input              │
│    • Allocate vmotionos_thread structure    │
│    • Call extraction function               │
└─────────────────┬───────────────────────────┘
                  │
                  ▼
          ┌───────────────┐
          │ vmotionos_    │
          │   thread      │◄─── Allocated empty structure
          │ (empty)       │
          └───────┬───────┘
                  │
                  ▼
┌─────────────────────────────────────────────┐
│      vmotionos_extract_thread_data()        │
│  • Find task by PID                         │
│  • Extract CPU registers                    │
│  • Extract memory layout                    │
│  • Extract VMA information                  │
└─────────────────┬───────────────────────────┘
                  │
        ┌─────────┼─────────────────────────┐
        │         │                         │
        ▼         ▼                         ▼
   ┌─────────┐ ┌─────────┐           ┌─────────────┐
   │task_    │ │ pt_regs │           │   mm_struct │
   │struct   │ │registers│           │ + VMA list  │
   └────┬────┘ └────┬────┘           └──────┬──────┘
        │           │                       │
        └───────────┼───────────────────────┘
                    │
                    ▼
          ┌───────────────┐
          │ vmotionos_    │◄─── Filled with:
          │   thread      │     • PID: 470
          │  (filled)     │     • Comm: "user"
          └───────┬───────┘     • 21 CPU registers
                  │             • Memory segments
                  │             • 11 VMAs with paths
                  ▼
┌─────────────────────────────────────────────┐
│       vmotionos_print_thread_data()         │
│  • Print CPU register dump                  │
│  • Print memory layout info                 │
│  • Print all VMA details                    │
└─────────────────┬───────────────────────────┘
                  │
                  ▼
           ┌─────────────┐
           │  Console    │◄─── dmesg output:
           │   Output    │     • Registers: RIP=0x401234
           │ (dmesg)     │     • VMAs: 0x400000-0x401000
           └─────────────┘     • Paths: /root/user
                  │
                  ▼
┌─────────────────────────────────────────────┐
│       vmotionos_send_thread_data()          │
│  • Calculate optimized message size         │
│  • Create vmotionos_message wrapper         │
│  • Copy only actual VMAs (not all 256)      │
│  • Call UDP send function                   │
└─────────────────┬───────────────────────────┘
                  │
                  ▼
          ┌───────────────┐
          │ vmotionos_    │◄─── Optimized packet:
          │   message     │     • msg_type: CREATE_THREAD
          │ (wire format) │     • data_size: ~3KB
          └───────┬───────┘     • Only 11 VMAs
                  │
                  ▼
┌─────────────────────────────────────────────┐
│         vmotionos_send_message()            │
│  • Create UDP socket (AF_INET)              │
│  • Set destination 192.168.122.81:1104     │
│  • Call kernel_sendmsg()                    │
└─────────────────┬───────────────────────────┘
                  │
                  ▼
            ┌───────────┐
            │    UDP    │
            │  Packet   │◄─── Network transmission
            │ (on wire) │     3-4KB optimized data
            └─────┬─────┘
                  │
└─────────────────┼─────────────────────────────────────────────────────────┘
                  │
              ════▼═══════════ NETWORK ══════════════
                  │
┌─────────────────▼─────────────────────────────────────────────────────────┐
                          SERVER SIDE (Node 2)
                  │
                  ▼
        ┌─────────────────┐
        │   UDP Socket    │◄─── Listening on port 1104
        │  (listening)    │
        └─────────┬───────┘
                  │
                  ▼
┌─────────────────────────────────────────────┐
│          udp_server_thread()                │◄── Kernel thread loop
│  • kernel_recvmsg() receives packet         │
│  • Validate message type and size           │
│  • Extract vmotionos_thread data            │
│  • Call processing function                 │
└─────────────────┬───────────────────────────┘
                  │
                  ▼
       ┌────────────────────┐
       │   Validation       │◄─── Diamond for decision:
       │ Message size OK?   │     • Type == CREATE_THREAD?
       │ VMA count valid?   │     • Size >= expected?
       └─────────┬──────────┘     • VMAs fit in packet?
                 │
                 ▼ ✓ Valid
┌─────────────────────────────────────────────┐
│    vmotionos_process_received_thread()      │
│  • Print "=== THREAD DATA RECEIVED ==="    │
│  • Display complete register dump           │
│  • Display memory layout                    │
│  • Display ALL VMA information              │
└─────────────────┬───────────────────────────┘
                  │
                  ▼
           ┌─────────────┐
           │  Console    │◄─── Server dmesg output:
           │   Output    │     • "Received CREATE_THREAD"
           │  (Server)   │     • Complete thread state
           └─────┬───────┘     • Ready for recreation
                 │
                 ▼
      ┌──────────────────────┐
      │  [FUTURE FUNCTION]   │◄─── Ready for implementation:
      │ Process Recreation   │     • vmotionos_copy_x86_registers()
      │   • Restore regs     │     • vmotionos_copy_vma_structure()
      │   • Create VMAs      │     • Resume at thread->regs.ip
      │   • Resume thread    │
      └──────────────────────┘

└─────────────────────────────────────────────────────────────────────────────┘



Input Data (Circle):           Intermediate (Hexagon):      Output Data (Circle):
┌─────────────┐               ┌─────────────────┐          ┌─────────────┐
│    "470"    │──────────────►│ vmotionos_thread│─────────►│  UDP Packet │
│  User PID   │               │   (in memory)   │          │ (wire format)│
└─────────────┘               │                 │          └─────────────┘
                              │ • pid: 470      │          
                              │ • comm: "user"  │          
                              │ • regs: [21]    │          
                              │ • mm: layout    │          
                              │ • vmas: [11]    │          
                              └─────────────────┘          


User Write → ┌─────────────────────┐ → ┌─────────────────────┐ → ┌─────────────────────┐
             │ vmotions_proc_write │   │vmotionos_extract_   │   │vmotionos_print_     │
             │                     │   │  thread_data        │   │  thread_data        │
             └─────────────────────┘   └─────────────────────┘   └─────────────────────┘
                      ▼                            ▼                            ▼
             ┌─────────────────────┐ → ┌─────────────────────┐ → ┌─────────────────────┐
             │vmotionos_send_      │   │vmotionos_send_      │   │ udp_server_thread   │
             │  thread_data        │   │   message           │   │                     │
             └─────────────────────┘   └─────────────────────┘   └─────────────────────┘
                                                ▼
                                       ┌─────────────────────┐
                                       │vmotionos_process_   │
                                       │ received_thread     │
                                       └─────────────────────┘




