#include <linux/pid.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/sched/task.h>
#include <linux/sched/mm.h>
#include <linux/mm.h>
#include <linux/ramfs.h>

struct field_arch {
	struct pt_regs regsets;
	unsigned long fs;
	unsigned long gs;
};

struct remote_wrapper {
	int pid;
	pid_t opid;
	pid_t otgid;
	char remote_name[256];
	unsigned long task_size;
	unsigned long stack_start;
	unsigned long env_start;
	unsigned long env_end;
	unsigned long arg_start;
	unsigned long arg_end;
	unsigned long start_brk;
	unsigned long brk;
	unsigned long start_code;
	unsigned long end_code;
	unsigned long start_data;
	unsigned long end_data;
	unsigned int personality;
	unsigned long def_flags;
	int map_count;
	struct field_arch arch;
	char *exe_path;
	struct vma_desc *vma_descs;
};

struct remote_request {
	struct remote_wrapper *remote;
	char *remote_name;
};

struct vma_desc {
	unsigned long start;
	unsigned long end;
	vm_flags_t flags;
	unsigned long pgoff;
	char *file_path;
};

/*fs/udp_module.c  -- fs support for remote*/
extern int call_remote_storage(struct remote_request *request);

int add_arch_info(struct task_struct *task, struct field_arch *arch);

extern int process_message(char *buffer, struct remote_wrapper *wrapper);

extern int schedule_migrated_task(struct remote_wrapper *wrapper);

vm_fault_t vm_fault_handler(struct vm_fault *vmf);